import hmac
import hashlib
import binascii
import os
from commlib.proto import message_pb2


def create_null_signature(key, message):
    return None


def create_sha2_signature(key, message):
    message = message.encode()
    return hmac.new(key, message, hashlib.sha256).hexdigest().upper()


def create_sha3_signature(key, message):
    message = message.encode()
    return hmac.new(key, message, hashlib.sha3_224).hexdigest().upper()


def create_signing_string(message):

    signing_string = (
        str(message.collector)
        + str(message.sequence)
        + str(message.currenttime)
        + str(message.cipher)
        + str(message.mac)
        + str(message.payload)
    )

    signing_string = signing_string.replace("\\", "\\\\").replace(":", "\\:")
    signing_string.strip()

    return signing_string
