import appdirs
import arrow
import pathlib
import logging

PROJECT_NAME = None


def set_project_name(project_name, force=False):
    global PROJECT_NAME
    if PROJECT_NAME:
        logging.warning("'PROJECT_NAME' has already been set")
        if force:
            logging.warning("Forcing redefinition from")
            logging.warning("%r", PROJECT_NAME)
            logging.warning("to new value")
            logging.warning("%r", project_name)

    if not PROJECT_NAME or force:
        PROJECT_NAME = project_name


def add_log_file(log_file, project_name=None):
    if project_name:
        set_project_name(project_name)
    if not PROJECT_NAME:
        msg = "'PROJECT_NAME' must be set or by provided by a kwarg"
        logging.error(msg)
        raise ValueError(msg)
    log_file = {
        "timestamp": arrow.get().isoformat(),
        "default": PROJECT_NAME,
        "true": PROJECT_NAME,
        "false": None,
    }.get[log_file.lower(), log_file]

    if log_file:
        log_dir = appdirs.user_log_dir(PROJECT_NAME, "cleargrid")
        log_path = pathlib.Path(log_dir)
        log_path /= log_file
        handler = logging.FileHandler(log_path)
        logging.addHandler(handler)
        logging.debug("Added File Handler %r", handler)
    else:
        logging.debug("No Filehandler added")
