import logging
import time

from cleargrid.util.subprocess import ProcessManager

FORMAT = (
    "%(asctime)s - %(filename)12s:%(lineno)4d - "
    "%(threadName)10s[%(levelname)7s]:%(message)s"
)

logging.basicConfig(level=logging.DEBUG, format=FORMAT)


def dead(process):
    if not process.is_alive():
        logging.error("%s process unexpectedly exited", process.name)
        return True
    return False


def start():
    logging.debug("start")
    gps = ProcessManager("GPS Client", ["gps_client"]).start()
    mc3 = ProcessManager("MC3 Integration", ["mc3_integration"]).start()
    interface = ProcessManager("Interface", ["mission_controller"]).start()
    processes = (gps, mc3, interface)
    try:
        while True:
            time.sleep(5)
            if any(dead(p) for p in processes):
                break
    except Exception:
        logging.exception("Unhandled Exception")
    finally:
        for p in processes:
            p.shutdown()
    logging.info("All processes Exited")
