import hmac
import unittest
from binascii import unhexlify
from math import ceil

from cryptography.hazmat.backends import default_backend
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.primitives.kdf.kbkdf import KBKDFHMAC, CounterLocation, Mode
import tskdf


class TSKDFTestCase(unittest.TestCase):
    """Examples of the TSKDF function"""

    def test_tskdf(self):
        key = "SECRET_KEY"
        kdf = tskdf.TSKDF(key, 32)
        key11, iv11 = kdf.derive(1, 1)
        self.assertEqual(len(key11), 32)
        self.assertEqual(len(iv11), 16)
        self.assertNotEqual(key11, iv11)

        key12, iv12 = kdf.derive(1, 2)
        self.assertEqual(len(key12), 32)
        self.assertEqual(len(iv12), 16)
        self.assertNotEqual(key11, key12)
        self.assertNotEqual(iv11, iv12)
        self.assertNotEqual(key12, iv12)

        key22, iv22 = kdf.derive(2, 2)
        self.assertEqual(len(key22), 32)
        self.assertEqual(len(iv22), 16)
        self.assertNotEqual(key11, key22)
        self.assertNotEqual(key12, key22)
        self.assertNotEqual(iv11, iv22)
        self.assertNotEqual(iv12, iv22)
        self.assertNotEqual(key22, iv22)

        key21, iv21 = kdf.derive(2, 1)
        self.assertEqual(len(key21), 32)
        self.assertEqual(len(iv21), 16)
        self.assertNotEqual(key11, key21)
        self.assertNotEqual(key12, key21)
        self.assertNotEqual(key22, key21)
        self.assertNotEqual(iv11, iv21)
        self.assertNotEqual(iv12, iv21)
        self.assertNotEqual(iv22, iv21)
        self.assertNotEqual(key21, iv21)

        kdfA1 = tskdf.TSKDF(key, 32, label=b"AbuCnC LOB to Collector")
        keyA1, ivA1 = kdfA1.derive(2, 1)
        self.assertEqual(len(keyA1), 32)
        self.assertEqual(len(ivA1), 16)
        self.assertNotEqual(key12, keyA1)
        self.assertNotEqual(key11, keyA1)
        self.assertNotEqual(key22, keyA1)
        self.assertNotEqual(key21, keyA1)
        self.assertNotEqual(iv12, ivA1)
        self.assertNotEqual(iv11, ivA1)
        self.assertNotEqual(iv22, ivA1)
        self.assertNotEqual(iv21, ivA1)
        self.assertNotEqual(keyA1, ivA1)


if __name__ == "__main__":
    unittest.main()
