import gps
import requests
import logging


def watch(w):
    for i, p in enumerate(w.stream):
        if hasattr(p, "position"):
            requests.post(
                "http://127.0.0.1/update",
                json={
                    "location": (
                        p.timestamp.timestamp,
                        p.position.latitude,
                        p.position.longitude,
                    )
                },
            )


def main():
    logging.basicConfig(level=logging.INFO)
    while True:
        c = gps.get_client()
        logging.info(c.version())
        with c.watch() as w:
            try:
                watch(w)
            except Exception:
                logging.exception("Error in Watcher, retrying")


if __name__ == "__main__":
    main()
