import unittest
from cryptography.hazmat.primitives.ciphers import Cipher, algorithms, modes
from cryptography.hazmat.backends import default_backend
from binascii import unhexlify
import encryptor


class OpenSSLvsPythonCrypto(unittest.TestCase):
    """OpenSSL when encrypting and decrypting in CTR mode does not pad the
    Cipher text to the block size"""

    def test_encryptor(self):
        encryptor_instance = encryptor.Encryptor()
        key = unhexlify(
            "00010203040506070809101112131415" "16171819202122232425262728293031"
        )
        self.assertEqual(32, len(key))
        iv = unhexlify("000000000000000000000000031b383e")
        self.assertEqual(16, len(iv))

        payload = bytes("testPayload", "utf-8")
        ct = encryptor_instance.encrypt_payload(key, iv, payload)

        self.assertNotEqual(ct, payload)

        pt = encryptor_instance.decrypt_payload(key, iv, ct)
        self.assertEqual(payload, pt)


if __name__ == "__main__":
    unittest.main()

