import logging
import threading
import unittest
import unittest.mock as mock
from os import pipe

from .process_manager import PipeFollower


class TestPipeFollower(unittest.TestCase):
    def test_pipe(self):
        info_called = threading.Event()
        read, write = pipe()
        read = open(read, "rb", buffering=1)
        write = open(write, "wb", buffering=1)

        f = PipeFollower("a", "test", read)

        def side_effect(fmt, *args):
            info_called.set()
            logging.debug("would have been logged: %r:%r", fmt, args)

        f.logger.info = mock.MagicMock(side_effect=side_effect)
        f.start()
        write.write(b"Testing\n")
        write.close()
        info_called.wait(5)
        logging.debug("Assert_called_with")
        f.logger.info.assert_called_with("%s", b"Testing")
        logging.debug("Joining")
        f.join()
        self.assertFalse(f.is_alive(), msg="Thread is still alive")
        logging.debug("Done")
