import os
import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()
with open("VERSION", "r") as ver:
    version = ver.read().strip()
if "CI_COMMIT_REF_SLUG" in os.environ:
    if os.environ['CI_COMMIT_REF_SLUG'] == "master":
        version += "b{!s}".format(os.environ["PUSHTAG"])
    else:
        version += "a{!s}".format(os.environ["PUSHTAG"])
else:
    version += ".dev{!s}".format(os.environ["PUSHTAG"])

setuptools.setup(
    name="commlib",
    version=version,
    author="ClearGrid",
    author_email="packaging@cleargrid.io",
    description="clearGRID Collector Communcation Library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(),  # ['commlib', 'commlib.settings', 'commlib.proto', 'commlib.UDP', 'commlib.crypto_lob']
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    install_requires=["protobuf"],
)

