
import logging
import threading
import time
import warnings

from cleargrid.mission_controller.config import config
from cleargrid.mission_controller.data import Datastore
from cleargrid.mission_controller.webserver import app


def main():
    warnings.simplefilter("error")
    logging.info("Worker threads started")

    # Start webserver
    logging.info("Starting Webserver")

    def persist_data():
        while True:
            time.sleep(config.save_interval)
            Datastore.persist_tracks_to_disk()

    x = threading.Thread(target=persist_data, daemon=True)
    x.start()

    app.run(config.webui_bind_address, config.webui_bind_port)
    # get mission data from magic_carpet


if __name__ == "__main__":
    main()
