webpackJsonp(["main"],{

/***/ "../../../../../src/$$_gendir lazy recursive":
/***/ (function(module, exports) {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncatched exception popping up in devtools
	return Promise.resolve().then(function() {
		throw new Error("Cannot find module '" + req + "'.");
	});
}
webpackEmptyAsyncContext.keys = function() { return []; };
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
module.exports = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = "../../../../../src/$$_gendir lazy recursive";

/***/ }),

/***/ "../../../../../src/app/app.component.css":
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__("../../../../css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, ".refresh_button {\n    padding-right:0.5em;\n    min-width: 2em;\n}", ""]);

// exports


/*** EXPORTS FROM exports-loader ***/
module.exports = module.exports.toString();

/***/ }),

/***/ "../../../../../src/app/app.component.html":
/***/ (function(module, exports) {

module.exports = "<!--The content below is only a placeholder and can be replaced.-->\n<div fxLayout=\"column\" fxFlexFill>\n  <div class=\"header\" fxFlex=\"nogrow\" fxLayout=\"row\" fxLayoutAlign=\"space-between center\">\n    <div>&nbsp;</div>\n    <h3>\n      {{title}}\n    </h3>\n    <div fxLayout=\"row\">\n      <div (click)=zoom()>\t&#128269;</div>\n      <div class=refresh_button *ngIf='!paused' (click)='toggle_updates()'>\n        &#9612;&#9612;\n      </div>\n      <div class=refresh_button *ngIf='paused' (click)='toggle_updates()'>\n        &nbsp;\n        &#9654;\n      </div>\n    </div>\n  </div>\n  <div fxLayout=\"row\" fxLayout.lt-md=\"column\" fxFlex=\"grow\">\n    <div fxFlex=\"20\" fxFlexOrder.lt-md=2 fxLayout=\"column\">\n      <div fxLayout=\"row\" fxFlex=\"1.5em\" fxLayoutAlign=\"space-around\">\n        <!-- tabs-->\n        <span (click)='select_tab(0)'>Layers</span>\n        <span (click)='select_tab(1)'>Config</span>\n      </div>\n      <div fxLayout=\"row\" fxFlex=\"grow\">\n        <layer-selector *ngIf='selected_tab==0' fxFlexFill></layer-selector>\n        <config *ngIf='selected_tab==1' fxFlexFill></config>\n      </div>\n    </div>\n    <leaflet-map fxFlex=\"grow\" fxFlexOrder.lt-md=1 #map></leaflet-map>\n  </div>\n  <status-footer class=\"footer\" fxFlex=\"1.5em\" fxLayout=\"row\" fxLayoutAlign=\"space-around center\">\n  </status-footer>\n</div>"

/***/ }),

/***/ "../../../../../src/app/app.component.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__update_service__ = __webpack_require__("../../../../../src/app/update.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var AppComponent = (function () {
    function AppComponent(config, updater, controller) {
        this.config = config;
        this.updater = updater;
        this.controller = controller;
        this.title = 'app';
        this.paused = false;
        this.selected_tab = 0;
    }
    AppComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.controller.get_layers().subscribe(function (layers) {
            _this.config.add_layers(layers);
        });
        this.updater.start();
    };
    AppComponent.prototype.zoom = function () {
        var _this = this;
        this.controller.get_bounds().subscribe(function (bounds) {
            console.log(bounds);
            _this.map.zoom(bounds);
        });
    };
    AppComponent.prototype.select_tab = function (tab) {
        this.selected_tab = tab;
    };
    AppComponent.prototype.toggle_updates = function () {
        if (this.paused) {
            this.updater.start();
        }
        else {
            this.updater.stop();
        }
        this.paused = !this.paused;
    };
    return AppComponent;
}());
__decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_14" /* ViewChild */])('map'),
    __metadata("design:type", Object)
], AppComponent.prototype, "map", void 0);
AppComponent = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["n" /* Component */])({
        selector: 'app-root',
        template: __webpack_require__("../../../../../src/app/app.component.html"),
        styles: [__webpack_require__("../../../../../src/app/app.component.css")]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__config_service__["a" /* ConfigService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_2__update_service__["a" /* UpdateService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__update_service__["a" /* UpdateService */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_3__controller_service__["a" /* ControllerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__controller_service__["a" /* ControllerService */]) === "function" && _c || Object])
], AppComponent);

var _a, _b, _c;
//# sourceMappingURL=app.component.js.map

/***/ }),

/***/ "../../../../../src/app/app.module.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_platform_browser__ = __webpack_require__("../../../platform-browser/@angular/platform-browser.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_http__ = __webpack_require__("../../../http/@angular/http.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__angular_forms__ = __webpack_require__("../../../forms/@angular/forms.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__angular_flex_layout__ = __webpack_require__("../../../flex-layout/@angular/flex-layout.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__app_component__ = __webpack_require__("../../../../../src/app/app.component.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__footer_component__ = __webpack_require__("../../../../../src/app/footer.component.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__layer_component__ = __webpack_require__("../../../../../src/app/layer.component.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__map_component__ = __webpack_require__("../../../../../src/app/map.component.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__layer_service__ = __webpack_require__("../../../../../src/app/layer.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__update_service__ = __webpack_require__("../../../../../src/app/update.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__historical_service__ = __webpack_require__("../../../../../src/app/historical.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__config_component__ = __webpack_require__("../../../../../src/app/config.component.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};















var AppModule = (function () {
    function AppModule() {
    }
    return AppModule;
}());
AppModule = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["L" /* NgModule */])({
        declarations: [
            __WEBPACK_IMPORTED_MODULE_5__app_component__["a" /* AppComponent */], __WEBPACK_IMPORTED_MODULE_8__map_component__["a" /* MapComponent */], __WEBPACK_IMPORTED_MODULE_6__footer_component__["a" /* FooterComponent */], __WEBPACK_IMPORTED_MODULE_7__layer_component__["a" /* LayerComponent */], __WEBPACK_IMPORTED_MODULE_10__config_service__["b" /* MapToIterable */], __WEBPACK_IMPORTED_MODULE_14__config_component__["a" /* ConfigComponent */]
        ],
        imports: [
            __WEBPACK_IMPORTED_MODULE_0__angular_platform_browser__["a" /* BrowserModule */], __WEBPACK_IMPORTED_MODULE_4__angular_flex_layout__["a" /* FlexLayoutModule */], __WEBPACK_IMPORTED_MODULE_2__angular_http__["b" /* HttpModule */], __WEBPACK_IMPORTED_MODULE_3__angular_forms__["a" /* FormsModule */]
        ],
        providers: [__WEBPACK_IMPORTED_MODULE_9__layer_service__["a" /* LayerService */], __WEBPACK_IMPORTED_MODULE_10__config_service__["a" /* ConfigService */], __WEBPACK_IMPORTED_MODULE_11__controller_service__["a" /* ControllerService */], __WEBPACK_IMPORTED_MODULE_12__update_service__["a" /* UpdateService */], __WEBPACK_IMPORTED_MODULE_13__historical_service__["a" /* HistoricalService */]],
        bootstrap: [__WEBPACK_IMPORTED_MODULE_5__app_component__["a" /* AppComponent */]]
    })
], AppModule);

//# sourceMappingURL=app.module.js.map

/***/ }),

/***/ "../../../../../src/app/config.component.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ConfigComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__historical_service__ = __webpack_require__("../../../../../src/app/historical.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var ConfigComponent = (function () {
    function ConfigComponent(historical, config, controller) {
        this.historical = historical;
        this.config = config;
        this.controller = controller;
        this.tracks = [];
        this.ref_tracks = [];
        this.api_server = "";
        this.refresh_interval = 5;
    }
    ConfigComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.reload_tracks();
        this.config.refresh_interval.subscribe(function (interval) {
            _this.refresh_interval = interval / 1000;
        });
        this.config.api_server$.subscribe(function (srv) {
            _this.reload_tracks();
            _this.load_ref_tracks();
            _this.api_server = srv;
        });
    };
    ConfigComponent.prototype.reload_tracks = function () {
        var _this = this;
        this.controller.get_previous_tracks().subscribe(function (tracks) {
            tracks.forEach(function (element) {
                element.selected = element.track_id in _this.historical.tracks;
            });
            _this.tracks = tracks;
        });
    };
    ConfigComponent.prototype.load_ref_tracks = function () {
        var _this = this;
        this.controller.reference_tracks().subscribe(function (tracks) {
            _this.ref_tracks = tracks;
        });
    };
    ConfigComponent.prototype.toggle_track = function (track) {
        if (track.selected) {
            this.historical.add_track(track.track_id);
        }
        else {
            this.historical.remove_track(track.track_id);
        }
    };
    ConfigComponent.prototype.set_server = function () {
        this.config.api_server = this.api_server;
    };
    ConfigComponent.prototype.set_refresh = function () {
        this.config.set_refresh_interval(this.refresh_interval);
    };
    return ConfigComponent;
}());
ConfigComponent = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["n" /* Component */])({
        selector: 'config',
        template: "\n    <div fxLayout=\"column\">\n\n      <div fxLayout=\"row\" fxLayoutAlign=\"space-around\">\n        <span>Server</span>\n        <span><input [(ngModel)]=api_server></span>\n        <button (click)='set_server()'>set</button>\n      </div>\n\n      <div fxLayout=\"row\" fxLayoutAlign=\"space-around\">\n        <span>Refresh Interval</span>\n        <span><input [(ngModel)]=refresh_interval></span>\n        <button (click)='set_refresh()'>set</button>\n      </div>\n\n      <div fxLayout=\"row\" fxLayoutAlign=\"space-around\">\n        <span>Reference Track</span>\n        <span>\n          <select [(ngModel)]=config.reference_track>\n            <option default value=None>None</option>\n            <option *ngFor='let track of ref_tracks' (value)='track'>{{track}}</option>\n          </select>\n        </span>\n      </div>\n\n      <div>\n        <h3>Selected Tracks</h3>\n        <div fxLayout=\"column\">\n          <div fxLayout=\"row\" fxLayoutAlign=\"space-around\">\n            <span fxFlex=20><b>Selected</b></span>\n            <span fxFlex=60><b>Timestamp</b></span>\n            <span fxFlex=25><b>Track ID</b></span>\n          </div>        \n          <div *ngFor='let track of tracks' fxLayout=\"row\" fxLayoutAlign=\"space-around\">\n            <input fxFlex=20 type=checkbox [(ngModel)]='track.selected' (change)='toggle_track(track)'>\n            <span fxFlex=60>{{track.timestamp|date:'short'}}</span>\n            <span fxFlex=25>{{track.track_id}}</span>\n          </div>\n        </div>\n      </div>\n    </div>",
        styles: [
            '.ok,.good,.pass {color:lawngreen;}',
            '.warn,.alert,.warning {color:yellow;}',
            '.fail,.trouble,.error {color:red}',
            '.status-text {text-shadow:-1px 0 darkgrey, 0 1px darkgrey, 1px 0 darkgrey, 0 -1px darkgrey;}'
        ]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__historical_service__["a" /* HistoricalService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__historical_service__["a" /* HistoricalService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_2__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__config_service__["a" /* ConfigService */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_3__controller_service__["a" /* ControllerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__controller_service__["a" /* ControllerService */]) === "function" && _c || Object])
], ConfigComponent);

var _a, _b, _c;
//# sourceMappingURL=config.component.js.map

/***/ }),

/***/ "../../../../../src/app/config.service.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export LayerConfig */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ConfigService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return MapToIterable; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__ = __webpack_require__("../../../../rxjs/_esm5/Rx.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__layer_service__ = __webpack_require__("../../../../../src/app/layer.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var LayerConfig = (function () {
    function LayerConfig() {
        this.update = true;
    }
    return LayerConfig;
}());

var ConfigService = (function () {
    function ConfigService(layer_service) {
        this.layer_service = layer_service;
        this._refresh_interval = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */](5000);
        this.refresh_interval = this._refresh_interval.asObservable();
        this._api_server = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */]("");
        this.api_server$ = this._api_server.asObservable();
        this._reference_track = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */]("");
        this.reference_track$ = this._reference_track.asObservable();
        this._layers = {};
        this.layers = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["c" /* Subject */]();
        this.layer_update = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["c" /* Subject */]();
    }
    Object.defineProperty(ConfigService.prototype, "api_server", {
        get: function () {
            return this._api_server.getValue();
        },
        set: function (value) {
            this._api_server.next(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ConfigService.prototype, "reference_track", {
        get: function () {
            return this._reference_track.getValue();
        },
        set: function (name) {
            this._reference_track.next(name);
            console.log('Reference track set to ' + name);
            this.add_layers({
                ref_track: {
                    url: '/reference/' + name,
                    type: 'geojson',
                    active: true,
                    label: name + ' Reference Track',
                    priority: 0,
                    update: false
                }
            });
        },
        enumerable: true,
        configurable: true
    });
    ConfigService.prototype.set_refresh_interval = function (v) {
        this._refresh_interval.next(v * 1000);
    };
    ConfigService.prototype.get_layers = function () {
        return this._layers;
    };
    ConfigService.prototype.add_layers = function (layers) {
        for (var id in layers) {
            var layer = layers[id];
            this._layers[id] = layer;
            if (layer.active) {
                this.layer_service.add(layer);
            }
        }
        this.layers.next(this._layers);
    };
    ConfigService.prototype.toggle_layer = function (layer) {
        this._layers[layer].active = !this._layers[layer].active;
        var update = {};
        update[layer] = this._layers[layer];
        this.layer_update.next(update);
        if (this._layers[layer].active) {
            this.layer_service.add(this._layers[layer]);
        }
        else {
            this.layer_service.remove(this._layers[layer]);
        }
    };
    return ConfigService;
}());
ConfigService = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["B" /* Injectable */])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__layer_service__["a" /* LayerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__layer_service__["a" /* LayerService */]) === "function" && _a || Object])
], ConfigService);

var MapToIterable = (function () {
    function MapToIterable() {
    }
    MapToIterable.prototype.transform = function (dict) {
        var a = [];
        for (var key in dict) {
            if (dict.hasOwnProperty(key)) {
                a.push({ key: key, value: dict[key] });
            }
        }
        return a;
    };
    return MapToIterable;
}());
MapToIterable = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["V" /* Pipe */])({
        name: 'items'
    })
], MapToIterable);

var _a;
//# sourceMappingURL=config.service.js.map

/***/ }),

/***/ "../../../../../src/app/controller.service.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ControllerService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__ = __webpack_require__("../../../../rxjs/_esm5/Rx.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_http__ = __webpack_require__("../../../http/@angular/http.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_rxjs_operators__ = __webpack_require__("../../../../rxjs/_esm5/operators/index.js");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var ControllerService = (function () {
    function ControllerService(http, config) {
        var _this = this;
        this.http = http;
        this.config = config;
        this.api_server = "";
        this.config.api_server$.subscribe(function (srv) {
            _this.api_server = srv;
        });
    }
    ControllerService.prototype.get_location = function () {
        return this
            .get('/location');
    };
    ControllerService.prototype.get = function (url) {
        return this.http
            .get(this.api_server + url)
            .map(function (res) { return res.json(); });
    };
    ControllerService.prototype.reference_tracks = function () {
        return this.get('/reference/');
    };
    ControllerService.prototype.reference_track = function (name) {
        return this.get('/reference/' + name);
    };
    ControllerService.prototype.get_track = function () {
        return this
            .get('/track');
    };
    ControllerService.prototype.get_previous_tracks = function () {
        return this
            .get('/previous')
            .map(function (tracks) {
            tracks.forEach(function (t) {
                t.timestamp = new Date(t.timestamp);
            });
            return tracks;
        });
    };
    ControllerService.prototype.get_previous_track = function (track_id) {
        return this
            .get('/previous/' + track_id);
    };
    ControllerService.prototype.get_bounds = function () {
        return this
            .get('/bounds');
    };
    ControllerService.prototype.get_status = function () {
        return this
            .get('/status');
    };
    ControllerService.prototype.get_layers = function () {
        var layers = this.config.get_layers();
        if (Object.keys(layers).length === 0 && layers.constructor === Object) {
            layers = {
                track: { url: '/track', type: 'track', active: true, label: 'Track', priority: -10 },
                follow: { url: '/location', type: 'location', active: true, label: 'Follow', priority: -5 },
            };
        }
        return this
            .get('/keys')
            .pipe(Object(__WEBPACK_IMPORTED_MODULE_4_rxjs_operators__["catchError"])(function (err) {
            console.log(err);
            return __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["b" /* Observable */].throw('Unable to get layers from server ' + err);
            //return of(Object.keys(layers))
        }))
            .map(function (data) {
            data.forEach(function (element) {
                if (!(element in layers)) {
                    console.log('New Layer ' + element);
                    layers[element] = {
                        url: '/key/' + element,
                        type: 'geojson',
                        active: true,
                        label: element,
                        priority: 10
                    };
                }
            });
            return layers;
        });
    };
    return ControllerService;
}());
ControllerService = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["B" /* Injectable */])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__angular_http__["a" /* Http */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__angular_http__["a" /* Http */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_3__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__config_service__["a" /* ConfigService */]) === "function" && _b || Object])
], ControllerService);

var _a, _b;
//# sourceMappingURL=controller.service.js.map

/***/ }),

/***/ "../../../../../src/app/footer.component.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FooterComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__update_service__ = __webpack_require__("../../../../../src/app/update.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var FooterComponent = (function () {
    function FooterComponent(update) {
        this.update = update;
        this.states = [{ message: 'No Status', class: 'warn' }];
    }
    FooterComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.update.status.subscribe(function (status) { _this.states = status; });
    };
    return FooterComponent;
}());
FooterComponent = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["n" /* Component */])({
        selector: 'status-footer',
        template: "<div *ngFor='let state of states' class=\"status-text\" [class]=state.class>{{state.message}}</div>",
        styles: [
            '.ok,.good,.pass {color:lawngreen;}',
            '.warn,.alert,.warning {color:yellow;}',
            '.fail,.trouble,.error {color:red}',
            '.status-text {text-shadow:-1px 0 darkgrey, 0 1px darkgrey, 1px 0 darkgrey, 0 -1px darkgrey;}'
        ]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__update_service__["a" /* UpdateService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__update_service__["a" /* UpdateService */]) === "function" && _a || Object])
], FooterComponent);

var _a;
//# sourceMappingURL=footer.component.js.map

/***/ }),

/***/ "../../../../../src/app/historical.service.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HistoricalService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__ = __webpack_require__("../../../../rxjs/_esm5/Rx.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_leaflet__ = __webpack_require__("../../../../leaflet/dist/leaflet-src.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_leaflet___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_leaflet__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var HistoricalService = (function () {
    function HistoricalService(controller, config) {
        var _this = this;
        this.controller = controller;
        this.config = config;
        this._layer = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */](__WEBPACK_IMPORTED_MODULE_3_leaflet__["layerGroup"]([]));
        this.layer = this._layer.asObservable();
        this.tracks = {};
        this.reload_tracks();
        this.config.api_server$.subscribe(function (srv) {
            _this.reload_tracks();
        });
    }
    HistoricalService.prototype.reload_tracks = function () {
        var _this = this;
        for (var track_id in this.tracks) {
            delete this.tracks[track_id];
        }
        this.controller.get_previous_tracks().subscribe(function (tracks) {
            tracks.forEach(function (element) {
                _this.add_track(element.track_id);
            });
        });
    };
    HistoricalService.prototype.add_track = function (track_id) {
        var _this = this;
        this.controller.get_previous_track(track_id).subscribe(function (track) {
            _this.tracks[track_id] = track;
            _this.update();
        });
    };
    HistoricalService.prototype.remove_track = function (track_id) {
        delete this.tracks[track_id];
        this.update();
    };
    HistoricalService.prototype.update = function () {
        var layer_group = __WEBPACK_IMPORTED_MODULE_3_leaflet__["layerGroup"]([]);
        for (var _i = 0, _a = Object.values(this.tracks); _i < _a.length; _i++) {
            var track = _a[_i];
            console.log(track);
            var layer = __WEBPACK_IMPORTED_MODULE_3_leaflet__["geoJSON"](track, {
                style: function (f) {
                    return {
                        color: "#007800",
                        opacity: 0.5
                    };
                }
            });
            layer_group.addLayer(layer);
        }
        this._layer.next(layer_group);
    };
    return HistoricalService;
}());
HistoricalService = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["B" /* Injectable */])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__controller_service__["a" /* ControllerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__controller_service__["a" /* ControllerService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_4__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__config_service__["a" /* ConfigService */]) === "function" && _b || Object])
], HistoricalService);

var _a, _b;
//# sourceMappingURL=historical.service.js.map

/***/ }),

/***/ "../../../../../src/app/layer.component.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LayerComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var LayerComponent = (function () {
    function LayerComponent(config, ref) {
        this.config = config;
        this.ref = ref;
        this.layers = {};
        this.sorted_keys = [];
    }
    LayerComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.config.layers.subscribe(function (layers) {
            _this.layers = layers;
            _this.sorted_keys = Object.keys(layers).sort(function (a, b) {
                var a_pri = _this.layers[a].priority || 0;
                var b_pri = _this.layers[b].priority || 0;
                return a_pri - b_pri;
            });
        });
        this.config.layer_update.subscribe(function (update) {
            _this.update_layers(update);
        });
        this.ref.markForCheck();
    };
    LayerComponent.prototype.update_layers = function (update) {
        for (var id in update) {
            if (update[id] !== null) {
                this.layers[id] = update[id];
            }
            else {
                delete this.layers[id];
            }
        }
        this.ref.markForCheck();
    };
    LayerComponent.prototype.toggle = function (layer) {
        this.config.toggle_layer(layer);
    };
    return LayerComponent;
}());
LayerComponent = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["n" /* Component */])({
        selector: 'layer-selector',
        template: "\n    <div fxLayout=\"column\" fxLayout.lt-md=\"row\">\n      <div *ngFor='let key of sorted_keys' [class.active]=\"layer[key].active\" [class.inactive]=\"!layer[key].active\" class=\"layer-button\" (click)='toggle(key)'>\n        {{layer[key].label}}\n      </div>\n    </div>",
        styles: [
            '.active {background-color:lime;box-shadow: 2px 2px darkgrey;}',
            '.inactive {background-color:limegreen;box-shadow: 5px 5px darkgrey;}',
            '.layer-button {margin:20px;padding:10px;border-radius:10px;text-align:center; }'
        ]
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__config_service__["a" /* ConfigService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_0__angular_core__["k" /* ChangeDetectorRef */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_0__angular_core__["k" /* ChangeDetectorRef */]) === "function" && _b || Object])
], LayerComponent);

var _a, _b;
//# sourceMappingURL=layer.component.js.map

/***/ }),

/***/ "../../../../../src/app/layer.service.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LayerService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__ = __webpack_require__("../../../../rxjs/_esm5/Rx.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};


var LayerService = (function () {
    function LayerService() {
        // Observable string sources
        this.layer_command = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */]({});
        this.layer_command$ = this.layer_command.asObservable();
    }
    // Service message commands
    LayerService.prototype.add = function (layer) {
        this._dispatch({ layer: layer, command: 'add' });
    };
    LayerService.prototype.remove = function (layer) {
        this._dispatch({ layer: layer, command: 'remove' });
    };
    LayerService.prototype.update = function (layer) {
        this._dispatch({ layer: layer, command: 'update' });
    };
    LayerService.prototype._dispatch = function (command) {
        this.layer_command.next(command);
    };
    return LayerService;
}());
LayerService = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["B" /* Injectable */])()
], LayerService);

//# sourceMappingURL=layer.service.js.map

/***/ }),

/***/ "../../../../../src/app/map.component.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MapComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__layer_service__ = __webpack_require__("../../../../../src/app/layer.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__environments_environment__ = __webpack_require__("../../../../../src/environments/environment.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_leaflet__ = __webpack_require__("../../../../leaflet/dist/leaflet-src.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_leaflet___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_4_leaflet__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__historical_service__ = __webpack_require__("../../../../../src/app/historical.service.ts");
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var LayerRecord = (function () {
    function LayerRecord(layer) {
        this.loading = false;
        this.layer = null;
        this.loading = false;
        this.layer = layer;
    }
    return LayerRecord;
}());
var MapComponent = (function () {
    function MapComponent(layer_service, controller, historical) {
        this.layer_service = layer_service;
        this.controller = controller;
        this.historical = historical;
        this.layers = {};
        this.historical_layer = null;
    }
    MapComponent.prototype.ngOnInit = function () {
        var _this = this;
        this.map = __WEBPACK_IMPORTED_MODULE_4_leaflet__["map"]('map', {
            zoomControl: false,
            attributionControl: false,
            center: [51.1, -114.37],
            zoom: 13
        });
        __WEBPACK_IMPORTED_MODULE_4_leaflet__["control"].scale({ position: 'bottomright' }).addTo(this.map);
        __WEBPACK_IMPORTED_MODULE_4_leaflet__["control"].zoom({ position: 'topright' }).addTo(this.map);
        __WEBPACK_IMPORTED_MODULE_4_leaflet__["tileLayer"](__WEBPACK_IMPORTED_MODULE_3__environments_environment__["a" /* environment */].tile_server, {
            maxZoom: 18
        }).addTo(this.map);
        // this.map.on('layeradd', event => {
        //   console.log('added layer ' + event.layer._leaflet_id)
        // }).on('layerremove', event => {
        //   console.log('removed layer ' + event.layer._leaflet_id)
        // })
        this.layer_service.layer_command$.subscribe(function (command) {
            if ('command' in command && 'layer' in command) {
                var fn_name = command.command + '_' + command.layer.type;
                if (fn_name in _this) {
                    _this[fn_name].bind(_this)(command.layer);
                }
                else {
                    console.log('Function `' + fn_name + '` does not exist');
                    console.dir(command);
                }
            }
            else {
                console.log('Recieved invalid map command');
                console.dir(command);
            }
        });
        this.historical.layer.subscribe(function (layer) {
            var old_layer = _this.historical_layer;
            _this.historical_layer = layer;
            _this.historical_layer.addTo(_this.map);
            if (old_layer) {
                old_layer.remove();
            }
        });
    };
    MapComponent.prototype.zoom = function (bounds) {
        bounds = __WEBPACK_IMPORTED_MODULE_4_leaflet__["latLngBounds"]([
            [bounds.top, bounds.left],
            [bounds.bottom, bounds.right]
        ]);
        if (bounds.isValid()) {
            this.map.fitBounds(bounds);
        }
    };
    MapComponent.prototype.add_location = function (layer) {
        if (!(layer.label in this.layers)) {
            this.layers[layer.label] = new LayerRecord(null);
        }
        this.update_location(layer);
    };
    MapComponent.prototype.update_location = function (layer) {
        var _this = this;
        var id = layer.label;
        if (!this.layers[id].loading) {
            this.layers[id].loading = true;
            this.controller.get(layer.url).subscribe(function (location) {
                if (location) {
                    var new_layer = __WEBPACK_IMPORTED_MODULE_4_leaflet__["circleMarker"](location.location, {
                        radius: 5,
                        fillColor: "#000000",
                        color: "#000000",
                        weight: 1,
                        opacity: 1,
                        fillOpacity: 1
                    });
                    new_layer.addTo(_this.map);
                    _this.map.panTo(location.location);
                    var old_layer = _this.layers[id].layer;
                    if (old_layer && _this.map.hasLayer(old_layer)) {
                        _this.map.removeLayer(old_layer);
                    }
                    _this.layers[id] = new LayerRecord(new_layer);
                }
            });
        }
    };
    MapComponent.prototype.remove_location = function (layer) {
        this.remove_layer(layer);
    };
    MapComponent.prototype.add_track = function (layer) {
        if (!(layer.label in this.layers)) {
            this.layers[layer.label] = new LayerRecord(null);
        }
        this.update_track(layer);
    };
    MapComponent.prototype.update_track = function (layer) {
        var _this = this;
        var id = layer.label;
        if (!this.layers[id].loading) {
            this.layers[id].loading = true;
            this.controller.get(layer.url).subscribe(function (track) {
                var new_layer = __WEBPACK_IMPORTED_MODULE_4_leaflet__["polyline"](track, { color: 'blue' });
                new_layer.addTo(_this.map);
                var old_layer = _this.layers[id].layer;
                if (old_layer && _this.map.hasLayer(old_layer)) {
                    _this.map.removeLayer(old_layer);
                }
                _this.layers[id] = new LayerRecord(new_layer);
            });
        }
    };
    MapComponent.prototype.remove_track = function (layer) {
        this.remove_layer(layer);
    };
    MapComponent.prototype.add_geojson = function (layer) {
        if (!(layer.label in this.layers)) {
            this.layers[layer.label] = new LayerRecord(null);
        }
        this.update_geojson(layer);
    };
    MapComponent.prototype.update_geojson = function (layer) {
        var _this = this;
        var id = layer.label;
        var lr = this.layers[id];
        if (lr.loading === true) {
            console.log('Last update still Loading');
        }
        else {
            lr.loading = true;
            this.controller.get(layer.url).subscribe(function (feature) {
                var old_layer = lr.layer;
                var new_layer = __WEBPACK_IMPORTED_MODULE_4_leaflet__["geoJSON"](feature, {
                    pointToLayer: function (f, latlng) {
                        return __WEBPACK_IMPORTED_MODULE_4_leaflet__["circleMarker"](latlng, {
                            radius: 5,
                            fillColor: "#ff7800",
                            color: "#ff7800",
                            weight: 1,
                            opacity: 0.8,
                            fillOpacity: 0.8
                        });
                    },
                    style: function (feature) {
                        if (feature.geometry.type === 'Point') {
                            switch (feature.properties.state) {
                                case 'unheard': return { fillColor: "#bb0000", color: "#bb0000" };
                                case 'heard': return { fillColor: "#1735ed", color: "#1735ed" };
                                case 'complete': return { fillColor: "#18da3b", color: "#18da3b" };
                            }
                        }
                    }
                });
                new_layer.addTo(_this.map);
                if (old_layer) {
                    old_layer.clearLayers();
                    old_layer.remove();
                }
                _this.layers[id] = new LayerRecord(new_layer);
            });
        }
    };
    MapComponent.prototype.remove_geojson = function (layer) {
        this.remove_layer(layer);
    };
    MapComponent.prototype.add_tiles = function (layer) {
        if (!(layer.label in this.layers)) {
            this.layers[layer.label] = new LayerRecord(null);
        }
        this.update_tiles(layer);
    };
    MapComponent.prototype.update_tiles = function (layer) {
        var _this = this;
        var id = layer.label;
        var timestamp = Math.floor(Date.now() / 1000);
        var new_layer = __WEBPACK_IMPORTED_MODULE_4_leaflet__["tileLayer"](layer.url + '/{z}/{x}/{y}.png?t={timestamp}', {
            timestamp: timestamp,
            minZoom: 10,
            maxZoom: 18
        });
        new_layer.addTo(this.map);
        var swap = function () {
            var old_layer = _this.layers[id].layer;
            if (old_layer) {
                old_layer.remove();
            }
            _this.layers[id] = new LayerRecord(new_layer);
            new_layer.off('load', swap);
        };
        new_layer.on('load', swap);
    };
    MapComponent.prototype.remove_tiles = function (layer) {
        this.remove_layer(layer);
    };
    MapComponent.prototype.remove_layer = function (layer) {
        var old_layer = this.layers[layer.label].layer;
        if (old_layer) {
            old_layer.remove();
        }
        delete this.layers[layer.lable];
    };
    return MapComponent;
}());
MapComponent = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["n" /* Component */])({
        selector: 'leaflet-map',
        template: "\n    <link\n      href=\"https://unpkg.com/leaflet@1.0.3/dist/leaflet.css\"\n      rel=\"stylesheet\"\n    />\n    <link\n      href=\"https://unpkg.com/leaflet.markercluster@1.0.0/dist/MarkerCluster.Default.css\"\n      rel=\"stylesheet\"\n    />\n    <div class=\"map-wrapper\">\n      <div id=\"map\"></div>\n    </div>\n  ",
        styles: ['.map-wrapper,#map {height:100%;}'],
        host: {
            class: 'main-map'
        }
    }),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_1__layer_service__["a" /* LayerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_1__layer_service__["a" /* LayerService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_2__controller_service__["a" /* ControllerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__controller_service__["a" /* ControllerService */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_5__historical_service__["a" /* HistoricalService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_5__historical_service__["a" /* HistoricalService */]) === "function" && _c || Object])
], MapComponent);

var _a, _b, _c;
//# sourceMappingURL=map.component.js.map

/***/ }),

/***/ "../../../../../src/app/update.service.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Status */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UpdateService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__ = __webpack_require__("../../../../rxjs/_esm5/Rx.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__config_service__ = __webpack_require__("../../../../../src/app/config.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__layer_service__ = __webpack_require__("../../../../../src/app/layer.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__controller_service__ = __webpack_require__("../../../../../src/app/controller.service.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_util__ = __webpack_require__("../../../../util/util.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_util___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_util__);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var Status = (function () {
    function Status() {
    }
    return Status;
}());

var UpdateService = (function () {
    function UpdateService(config, layers, controller) {
        this.config = config;
        this.layers = layers;
        this.controller = controller;
        this._status = new __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["a" /* BehaviorSubject */]([]);
        this.status = this._status.asObservable();
        this.update = this.config.refresh_interval.switchMap(function (interval) { return __WEBPACK_IMPORTED_MODULE_0_rxjs_Rx__["b" /* Observable */].timer(0, interval); });
    }
    UpdateService.prototype.start = function () {
        var _this = this;
        this.update$ = this.update.subscribe(function (t) {
            console.log(t);
            _this.update_layers(t);
            _this.controller.get_layers().subscribe(function (layers) {
                _this.config.add_layers(layers);
            });
        });
    };
    UpdateService.prototype.update_layers = function (t) {
        var _this = this;
        var layers = this.config.get_layers();
        for (var layer_id in layers) {
            var layer = layers[layer_id];
            if (Object(__WEBPACK_IMPORTED_MODULE_5_util__["isNull"])(layer)) {
                console.log('layer ' + layer_id + ' is <null>');
                continue;
            }
            var active = layer.active, _a = layer.update, update = _a === void 0 ? true : _a;
            if (active && update) {
                this.layers.update(layer);
            }
        }
        this.controller.get_status().subscribe(function (status) {
            _this._status.next(status);
        });
    };
    UpdateService.prototype.stop = function () {
        this.update$.unsubscribe();
    };
    return UpdateService;
}());
UpdateService = __decorate([
    Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["B" /* Injectable */])(),
    __metadata("design:paramtypes", [typeof (_a = typeof __WEBPACK_IMPORTED_MODULE_2__config_service__["a" /* ConfigService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_2__config_service__["a" /* ConfigService */]) === "function" && _a || Object, typeof (_b = typeof __WEBPACK_IMPORTED_MODULE_3__layer_service__["a" /* LayerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_3__layer_service__["a" /* LayerService */]) === "function" && _b || Object, typeof (_c = typeof __WEBPACK_IMPORTED_MODULE_4__controller_service__["a" /* ControllerService */] !== "undefined" && __WEBPACK_IMPORTED_MODULE_4__controller_service__["a" /* ControllerService */]) === "function" && _c || Object])
], UpdateService);

var _a, _b, _c;
//# sourceMappingURL=update.service.js.map

/***/ }),

/***/ "../../../../../src/environments/environment.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return environment; });
// The file contents for the current environment will overwrite these during build.
// The build system defaults to the dev environment which uses `environment.ts`, but if you do
// `ng build --env=prod` then `environment.prod.ts` will be used instead.
// The list of which env maps to which file can be found in `.angular-cli.json`.
// The file contents for the current environment will overwrite these during build.
var environment = {
    production: false,
    tile_server: 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png'
};
//# sourceMappingURL=environment.js.map

/***/ }),

/***/ "../../../../../src/main.ts":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__("../../../core/@angular/core.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser_dynamic__ = __webpack_require__("../../../platform-browser-dynamic/@angular/platform-browser-dynamic.es5.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app_app_module__ = __webpack_require__("../../../../../src/app/app.module.ts");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__environments_environment__ = __webpack_require__("../../../../../src/environments/environment.ts");




if (__WEBPACK_IMPORTED_MODULE_3__environments_environment__["a" /* environment */].production) {
    Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_21" /* enableProdMode */])();
}
Object(__WEBPACK_IMPORTED_MODULE_1__angular_platform_browser_dynamic__["a" /* platformBrowserDynamic */])().bootstrapModule(__WEBPACK_IMPORTED_MODULE_2__app_app_module__["a" /* AppModule */])
    .catch(function (err) { return console.log(err); });
//# sourceMappingURL=main.js.map

/***/ }),

/***/ 0:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("../../../../../src/main.ts");


/***/ })

},[0]);
//# sourceMappingURL=main.bundle.js.map