import unittest
from cryptography.hazmat.primitives.ciphers import Cipher, algorithms, modes
from cryptography.hazmat.backends import default_backend
from binascii import unhexlify


class Encryptor(object):
    def __init__(self, backend=None):
        if backend:
            self.backend = backend
        else:
            self.backend = default_backend()

    def encrypt_payload(self, key, iv, payload):
        cipher = Cipher(algorithms.AES(key), modes.CTR(iv), backend=self.backend)
        encryptor = cipher.encryptor()
        ct = encryptor.update(payload) + encryptor.finalize()
        return ct

    def decrypt_payload(self, key, iv, payload):
        backend = default_backend()
        cipher = Cipher(algorithms.AES(key), modes.CTR(iv), backend=backend)
        decryptor = cipher.decryptor()
        pt = decryptor.update(payload) + decryptor.finalize()
        return pt
