# translation of the GPSGate api to python from behaviour of the
# ITRON Mobile collector. This is rough code for reference and
# is not intended to be run in any useful manner
from ctypes import *
from functools import wraps

api=windll.GateApiXP
sysfree=windll.oleaut32.SysFreeString

# error handling
# all of the api calls appear to use the same error handling mechanism
class APIError(Exception):pass

    
def handle_errors(fn):
    @wraps(fn)
    def inner(self,*args,**kwargs):
        with self.error:
            return fn(self,*args,**kwargs)
    return inner

class ErrorHandler():
    def __init__(self,handle):
        self.handle=handle

    def check_error(self):
        err_no=api.Error_ErrNum(self.handle)
        if err_no!=0:
            buffer=c_wchar_p()
            api.Error_ErrDesc(self.handle,byref(msg))
            msg=buffer.value
            sysfree(buffer)
            raise APIError(f"[{num}] {msg}")
        
    def __enter__(self):
        pass

    def __exit__(self, exc_type, exc_val, traceback):
        self.check_errors()
        

class GPSGateAPI():
    def __init__(self):
        self.handle=None
        self.error=None

    # reading from the gps
    def connect(self):
        self.handle=api.Simple_New()
        self.error=ErrorHandler(api.Simple_GetErrHandle())

    @handle_errors
    def open(self,mode):
        api.Simple_Open(self.handle,"_output")

    @handle_errors
    def start_gps_gate():
        # if desired/needed GpsGate can be started using the below line
        api.StartGpsGate(self.handle)

    def read(self,*,timeout=-1):
        buffer=c_wchar_p()
        # appears to return a 4k buffer that it allocates
        with self.error:
            r=api.Simple_Read(self.handle,timeout,byref(buffer))
        # the 4k buffer needs to be freed by us
        result=buffer.value
        sysfree(buffer)
        return result

    @handle_errors
    def close(self):
        api.Simple_Close(self.handle)

    def disconnect(self):
        api.Simple_Delete(self.handle)
        self.handle=None


    # registration

    def register(self,email,key,d):
        handle=None
        handle=api.L_New()
        # registation as used by ITRON Mobile Interface
        with ErrorHandler(api.L_GetErrHandle(handle)):
            api.L_Reg(
                handle,
                "sue.anderson@itron.com",
                "F0VqrIeR4fl9YUV63VSqV7GPmoVhfGhF",
                365
            )
        api.L_Delete(handle)

def main():
	api=GPSGateAPI()
	api.register()
	api.connect()
	api.open("_output")
	result=api.read(timeout=1)
	print(result)
	api.close()
	api.disconnect()
	
if __name__=="__main__":
    main()
