import logging
import time
import os

from cleargrid.util.subprocess import ProcessManager

FORMAT = (
    "%(asctime)s - %(filename)12s:%(lineno)4d - "
    "%(threadName)10s[%(levelname)7s]:%(message)s"
)

logging.basicConfig(level=logging.DEBUG, format=FORMAT)


def dead(process):
    if not process.is_alive():
        logging.error("%s process unexpectedly exited", process.name)
        return True
    return False


def start():
    logging.debug("starting processes")

    processes = (
        ProcessManager("Interface Server", ["mission_controller"]),
        ProcessManager("GPS Client", ["gps_client"]),
        ProcessManager("MC3 Integration", ["mc3_integration"]),
    )

    for p in processes:
        p.start()
        time.sleep(2)

    ProcessManager(
        "Start Chrome",
        [os.environ["COMSPEC"], "/C", 'start chrome "http://127.0.0.1/app/"'],
    ).start()

    try:
        while True:
            time.sleep(5)
            if any(dead(p) for p in processes):
                break
    except Exception:
        logging.exception("Unhandled Exception")
    finally:
        for p in processes:
            p.shutdown()

    logging.info("All processes Exited")
