import time
from commlib.settings import TICK_INTERVAL
from datetime import datetime


def timestamp_from_tick(tick):
    """
    RETURNS: 
        time (datetime): Naive timestamp 
    """
    unix_time = int(tick) * TICK_INTERVAL
    return datetime.utcfromtimestamp(unix_time)


def unix_from_tick(tick):
    """
    RETURNS: 
        time (datetime): Naive timestamp 
    """
    return int(tick) * TICK_INTERVAL


def tick_from_unix_timestamp(timestamp: int) -> str:
    """
    RETURNS: 
        tick (str): number of ticks from epoch
    """
    return str(int(timestamp / TICK_INTERVAL))


def derive_tick():
    return time.time() / TICK_INTERVAL


def collector_to_signing_key(collector_id):
    return f"collector_{collector_id}_key"

