import os
from email import message_from_file  # For Parsing PKG-INFO

import setuptools
from packaging.version import Version

with open("README.md", "r") as fh:
    long_description = fh.read()
try:
    with open("VERSION", "r") as ver:
        version = Version(ver.read().strip())
    if "CI_COMMIT_REF_SLUG" in os.environ:
        if os.environ["CI_COMMIT_REF_SLUG"] == "master":
            pre = "b{!s}".format(os.environ["PUSHTAG"])
        else:
            pre = "a{!s}".format(os.environ["PUSHTAG"])
    else:
        pre = ".dev{!s}".format(os.environ["PUSHTAG"])

    if version.post:
        post = f"r{version.post}"
    else:
        post = ""

    version = "".join((".".join(str(p) for p in version.release), pre, post,))
except FileNotFoundError:
    with open("PKG-INFO", "r") as pkg:
        info = message_from_file(pkg)
        version = info["Version"]

setuptools.setup(
    name="cgr-commlib",
    version=version,
    author="ClearGrid",
    author_email="packaging@cleargrid.io",
    description="clearGRID Collector Communcation Library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(),  # ['commlib', 'commlib.settings', 'commlib.proto', 'commlib.UDP', 'commlib.crypto_lob']
    classifiers=[
        "Programming Language :: Python :: 3",
        "Operating System :: OS Independent",
    ],
    url="https://gitlab.us-central-1.7627.network/cleargrid/abu/commlib",
    install_requires=["protobuf"],
)
