import glob
import json
import logging
import threading
import time
import warnings

from cleargrid.mission_controller.config import config
from cleargrid.mission_controller.data import Datastore, Location, Meter
from cleargrid.mission_controller.webserver import app


def main():
    warnings.simplefilter("error")
    logging.info("Worker threads started")

    logging.info('Loading meter locations "%s"', config.meters)
    for pattern in config.meters:
        logging.info(" Globing: %s", pattern)
        for filename in glob.iglob(pattern):
            logging.info("  Loading from: %s", filename)
            with open(filename, mode="r") as infile:
                for meter in json.load(infile):
                    if "idm" in meter:
                        idm = meter["idm"]
                    else:
                        idm = False
                    if meter["lon"] == 0 or meter["lat"] == 0:
                        continue
                    Datastore.add_meter(
                        Meter(
                            ert=meter["ert"],
                            scm=True,
                            idm=idm,
                            location=Location(meter["lon"], meter["lat"]),
                        )
                    )

    # Start webserver
    logging.info("Starting Webserver")

    def persist_data():
        while True:
            time.sleep(config.save_interval)
            Datastore.persist_tracks_to_disk()

    x = threading.Thread(target=persist_data, daemon=True)
    x.start()

    app.run(config.webui_bind_address, config.webui_bind_port)
    # get mission data from magic_carpet


if __name__ == "__main__":
    main()
