import configargparse
import logging
import appdirs
from pathlib import Path
from cleargrid.logging import add_log_file

config = None
FORMAT = "%(filename)s:%(lineno)d - %(threadName)s[%(levelname)s]:%(message)s"


def parse_args():
    global config
    p = configargparse.get_arg_parser(
        default_config_files=["/etc/cleargrid", "~/.cleargrid"]
    )
    p.add("-c", "--config", is_config_file=True, help="config file path")
    p.add_argument("--log-level", "-L", default="DEBUG", env_var="LOG_LEVEL")
    p.add_argument("--log-file", action="store_true", env_var="LOG_FILE")

    p.add_argument(
        "--datastore-path",
        default=appdirs.user_data_dir("mission_controller", "cleargrid"),
        env_var="DATASTORE_PATH",
    )
    p.add_argument(
        "--save-interval",
        default=300,
        type=int,
        env_var="SAVE_INTERVAL",
        help="Save interval in seconds",
    )

    p.add_argument(
        "--webui-bind-address",
        default="0.0.0.0",
        env_var="WEBUI_ADDRESS",
        type=str,
    )

    config = p.parse_known_args()[0]
    logging.basicConfig(
        format=FORMAT, level=getattr(logging, config.log_level),
    )
    add_log_file(config.log_file, "mission_controller")
    Path(config.datastore_path).mkdir(parents=True, exist_ok=True)
    logging.debug(config)
    logging.getLogger("matplotlib").setLevel(logging.WARNING)
    return config


if not config:
    parse_args()
