import time
from commlib.settings import TICK_INTERVAL
from datetime import datetime
import csv


def timestamp_from_tick(tick):
    """
    RETURNS: 
        time (datetime): Naive timestamp 
    """
    unix_time = int(tick) * TICK_INTERVAL
    return datetime.utcfromtimestamp(unix_time)


def unix_from_tick(tick):
    """
    RETURNS: 
        time (datetime): Naive timestamp 
    """
    return int(tick) * TICK_INTERVAL


def tick_from_unix_timestamp(timestamp: int) -> str:
    """
    RETURNS: 
        tick (str): number of ticks from epoch
    """
    return str(int(timestamp / TICK_INTERVAL))


def derive_tick():
    return time.time() / TICK_INTERVAL


def collector_to_signing_key(collector_id):
    return f"collector_{collector_id}_key"


def parse_meters_from_csv(csv_file):
    """
    Sort the meters into a list based on the serial and market
    ARGS: 
        csv (io.IOBase): CSV representation ITRON `prepare_collector_archive_file` csv 
    RETURNS: 
        meters (List): A list of meters by their serial & market ["serial1_market1", "serial2_market2"]
        serials (List): A list of serials
        markets (List): A list of markets
    """
    meters = []

    # Column number from magic_carpet
    SERIAL = 0
    MARKET = 9

    for row in csv_file:
        meter_repr = row[SERIAL] + "_" + row[MARKET]
        meters.append(meter_repr)

    meters = sorted(meters)
    serials = [meter.split("_")[0] for meter in meter in meters]
    markets = [meter.split("_")[1] for meter in meter in meters]

    return meters, serials, markets
