import configargparse
import logging


config = None
FORMAT = "%(filename)s:%(lineno)d - %(threadName)s[%(levelname)s]:%(message)s"


def parse_args():
    global config
    p = configargparse.get_arg_parser(
        default_config_files=["/etc/cleargrid", "~/.cleargrid"]
    )
    p.add("-c", "--config", is_config_file=True, help="config file path")
    p.add_argument(
        "--threads",
        default=5,
        env_var="WRITER_THREADS",
        dest="num_threads",
        type=int,
    )
    p.add_argument("--log-level", "-L", default="DEBUG", env_var="LOG_LEVEL")

    p.add_argument(
        "--api-server", default="http://127.0.0.1:8000", env_var="API_SERVER"
    )
    p.add_argument("--api-user", env_var="API_USER")
    p.add_argument("--api-password", env_var="API_PASSWORD")
    p.add_argument(
        "--datastore-path", default="data", env_var="DATASTORE_PATH"
    )
    p.add_argument("--payload_id", default=1, type=int, env_var="PAYLOAD_ID")
    p.add_argument(
        "--save-interval",
        default=300,
        type=int,
        env_var="SAVE_INTERVAL",
        help="Save interval in seconds",
    )

    p.add_argument(
        "--taip-bind-address", default="0.0.0.0", env_var="TAIP_BIND_ADDRESS"
    )
    p.add_argument(
        "--taip-bind-port", default=21000, env_var="TAIP_PORT", type=int
    )

    p.add_argument(
        "--webui-bind-port", default=80, env_var="WEBUI_PORT", type=int
    )
    p.add_argument(
        "--webui-bind-address",
        default="0.0.0.0",
        env_var="WEBUI_ADDRESS",
        type=str,
    )

    p.add_argument("--meters", nargs="+", default=[])  # TODO WHAT ARE METERS?

    config = p.parse_known_args()[0]
    logging.basicConfig(
        format=FORMAT, level=getattr(logging, config.log_level),
    )
    logging.debug(config)
    logging.getLogger("matplotlib").setLevel(logging.WARNING)
    return config


if not config:
    parse_args()
