from cleargrid.gps import get_client
from cleargrid.logging import add_log_file
import requests
import logging
import configargparse


def watch(w):
    for i, p in enumerate(w.stream):
        if hasattr(p, "position"):
            requests.post(
                "http://127.0.0.1/update",
                json={
                    "location": (
                        p.timestamp.timestamp,
                        p.position.latitude,
                        p.position.longitude,
                    )
                },
            )


def main():
    p = configargparse.get_arg_parser(
        default_config_files=["/etc/cleargrid", "~/.cleargrid"]
    )
    p.add("-c", "--config", is_config_file=True, help="config file path")
    p.add_argument("--log-level", "-L", default="DEBUG", env_var="LOG_LEVEL")
    p.add_argument("--log-file", action="store_true", env_var="LOG_FILE")
    args = p.parse_known_args()[0]

    logging.basicConfig(level=getattr(logging, args.log_level.upper()))
    add_log_file(args.log_file, "gps_client")

    while True:
        c = get_client()
        logging.info(c.version())
        with c.watch() as w:
            try:
                watch(w)
            except Exception:
                logging.exception("Error in Watcher, retrying")


if __name__ == "__main__":
    main()
