
def float_or_none(value):
    if value in [None, '?']:
        return None
    return float(value)

class Error(object):
    def __init__(self, time=None, horizontal=None, vertical=None, track=None, speed=None, climb=None):
        self.time = float_or_none(time)
        self.horizontal = float_or_none(horizontal)
        self.vertical = float_or_none(vertical)
        self.track = float_or_none(track)
        self.speed = float_or_none(speed)
        self.climb = float_or_none(climb)

    def __repr__(self):
        return f'Error({self.time}, {self.horizontal}, {self.vertical}, {self.track}, {self.speed}, {self.climb})'


class Position(object):
    def __init__(self, latitude=None, longitude=None, altitude=None):
        self.latitude = float_or_none(latitude)
        self.longitude = float_or_none(longitude)
        self.altitude = float_or_none(altitude)

    def __repr__(self):
        fmt = '{self.latitude},{self.longitude}'
        if self.altitude is not None:
            fmt += ' @ {self.altitude} m'
        return fmt.format(self=self)


class Velocity(object):
    def __init__(self, heading=None, ground_speed=None, climb=None):
        self.heading = float_or_none(heading)
        self.ground_speed = float_or_none(ground_speed)
        self.climb = float_or_none(climb)

    def __repr__(self):
        fmt = '{self.ground_speed} m/s @ {self.heading} degrees'
        if self.climb is not None:
            fmt += ' [{self.climb} m/s]'
        return fmt.format(self=self)
