from pysnmp.hlapi import *
from pysnmp import debug

# use specific flags or 'all' for full debugging
# debug.setLogger(debug.Debug('all'))


def gps_iterator():
    return bulkCmd(
        SnmpEngine(),
        CommunityData("public", mpModel=0),
        UdpTransportTarget(("192.168.2.1", 161)),
        ContextData(),
        0,
        4,
        ObjectType(ObjectIdentity("1.3.6.1.4.1.28952.6.1")),
        lookupMib=False,
        lexicographicMode=False,
    )


for errorIndication, errorStatus, errorIndex, varBinds in gps_iterator():

    if errorIndication:
        print(errorIndication)
    elif errorStatus:
        print(
            "%s at %s"
            % (
                errorStatus.prettyPrint(),
                errorIndex and varBinds[int(errorIndex) - 1][0] or "?",
            )
        )
    else:
        for varBind in varBinds:
            print(" = ".join([x.prettyPrint() for x in varBind]))
