import typing as _t

from setuptools.command.build_ext import build_ext
import subprocess

import cleargrid.images.alpinebuilder


class DockerImageBuilder(build_ext):
    def __init__(self):
        raise NotImplementedError
    
    def build_extension(self):
        subprocess.check_call(
            [
                "docker",
                "build",
                "--env",
                cleargrid.images.alpinebuilder.__version__,
            ]
        )


def build(setup_kwargs: _t.Dict[str, _t.Any]) -> None:
    setup_kwargs.update(
        {"cmdclass": dict(build_ext=DockerImageBuilder)}
    )
