from datetime import datetime
import os
import random
import uuid

from cleargrid.mc3_integration.data.models import (
    Meter,
    Endpoint,
    Extendeddlrequest,
    Extendedreading,
    Reading,
    Extendeddlreading,
)

CREATED_ENDPOINT_PKS = []


class FakeDataGenerator:
    """
    CREATE, UPDATE, or DELETE data within ORM
    """

    def __init__(self, **kwargs):
        with open(
            os.getcwd() + "\\mc3_integration\\test\\allstreets.txt"
        ) as f:
            self.addresses = f.read()
            self.addresses = self.addresses.split()

    def generate_lat_lng(self):
        """Generates a random lat, lng in Calgary"""
        long_left_bound = -114.232017
        long_right_bound = -113.905064
        lat_top_bound = 51.184446
        lat_bottom_bound = 50.876644

        latitude = random.uniform(lat_top_bound, lat_bottom_bound)
        longitude = random.uniform(long_left_bound, long_right_bound)
        return (round(latitude, 5), round(longitude, 5))

    def generate_street(self):
        """Generates a random street with low-ish likelihood of collision"""
        street_number = random.randint(0, 999)
        address = random.choice(self.addresses)
        return str(street_number) + " " + address

    def create_endpoint(self):
        global CREATED_ENDPOINT_PKS
        try:
            lat, lng = self.generate_lat_lng()
            meter = Meter.objects.create(
                PK=uuid.uuid4(),
                street=self.generate_street(),
                messagecount=1,
                isreadonly=1,
                isoutofroute=0,
                isduplicateoor=0,
                identifier=random.randint(0, 10000),
                sequencenumber=0,
                symbolcode=0,
                readcomplete=1,
                nonamr=0,
            )
            endpoint = Endpoint.objects.create(
                PK=uuid.uuid4(),
                # meterPK=meter.pk,
                meter=meter,
                identifier=random.randint(0, 10000),
                macaddress="",
                latitude=lat,
                longitude=lng,
                type="100G",
                scmerttype=random.choice([12, 156]),
                deviceclass=255,
                tamper1count=0,
                tamper2count=0,
                previoustamper1count=0,
                previoustamper2count=0,
            )
            CREATED_ENDPOINT_PKS.append(str(endpoint.PK))
            return (endpoint, meter)
        except Exception as e:
            print(e)

    def create_extendeddlRequest(self):
        global CREATED_ENDPOINT_PKS
        try:
            endpoint = random.choice(Endpoint.objects.all())
            meter = endpoint.meter
            extended_request = Extendeddlrequest.objects.create(
                PK=uuid.uuid4(),
                meter=meter,
                endpointidentifier=meter.identifier,
                markettype="test",
                sequencenumber=1,
                parentsequencenumber=1,
                isrequired=0,
                readstatus=0,
                requestorigin=1,
                command=1,
                parameters="test",
                securedrequest1="test",
                securedrequest2="test",
                ismanual=0,
                isextended=0,
                techdescriptor=1,
                commandinfo="test",
            )
            return extended_request
        except Exception as e:
            print(e)

    def create_extendeddlReading(self, extdlreq):
        global CREATED_ENDPOINT_PKS
        try:
            extenddlreading = Extendeddlreading.objects.create(
                PK=uuid.uuid4(),
                extdlreq=extdlreq.PK,
                timeoccurred=datetime.now(),
                operatorusername="bob",
                readdata1="test",
            )
            return extenddlreading
        except Exception as e:
            print(e)

    def create_extended_reading(self):
        global CREATED_ENDPOINT_PKS
        endpoint = random.choice(Endpoint.objects.all())
        meter = endpoint.meter
        try:
            existing_association = Extendedreading.objects.filter(
                meterPK=meter.PK
            ).all()
            if not existing_association:
                extended_reading = Extendedreading.objects.create(
                    PK=uuid.uuid4(),
                    meterPK=meter.PK,
                    readdatetime=datetime.now(),
                    readstatus=1,
                    sequencenumber=0,
                    readdata=0,
                )
                return extended_reading
            else:
                return None
        except Exception as e:
            print(e)

    def create_reading(self):
        """Generates data on a polled basis"""
        global CREATED_ENDPOINT_PKS

        endpoint = random.choice(Endpoint.objects.all())
        meter = endpoint.meter
        try:
            reading = Reading.objects.create(
                PK=uuid.uuid4(),
                meter=meter,
                timeoccurred=datetime.now(),
                rawvalue=random.randint(0, 10000),
                ismanual=0,
                packettype=0,
                packetdata="",
                packettime=datetime.now(),
                operatorusername="MobileAdministrator",
            )
            return reading
        except Exception as e:
            print(e)

    def update_endpoint(self):
        endpoint = random.choice(Endpoint.objects.all())
        lat, lng = self.generate_lat_lng()
        endpoint.latitude = lat
        endpoint.longitude = lng
        endpoint.save()
        return endpoint

    def update_meter(self):
        try:
            meter = random.choice(Meter.objects.all())
            meter.street = self.generate_street()
            meter.save()
            return meter
        except Exception as e:
            print(e)

    def update_extended_reading(self):
        global CREATED_ENDPOINT_PKS
        try:
            if len(CREATED_ENDPOINT_PKS) > 0:
                """
                We grab a PK to update from the ones we've created
                An ExtendedReading Creation should replicate an update and
                invoke a meter to be "read"
                """
                endpoint = Endpoint.objects.get(
                    PK=random.choice(CREATED_ENDPOINT_PKS)
                )
                meter = endpoint.meter
                extended_reading = Extendedreading.objects.create(
                    PK=uuid.uuid4(),
                    meterPK=meter.PK,
                    readdatetime=datetime.now(),
                    readstatus=1,
                    sequencenumber=0,
                    readdata=0,
                )
                return endpoint
            else:
                extended_reading = random.choice(Extendedreading.objects.all())
                extended_reading.readdatetime = datetime.now()
                extended_reading.save()
                return endpoint
        except Exception as e:
            print(e)

    def update_reading(self):
        global CREATED_ENDPOINT_PKS
        try:
            if len(CREATED_ENDPOINT_PKS) > 0:
                """
                We grab a PK to update from the ones we've created
                An Reading Creation should replicate an update and invoke a
                meter to be "read"
                """
                endpoint = Endpoint.objects.get(
                    pk=random.choice(CREATED_ENDPOINT_PKS)
                )
                meter = endpoint.meter
                reading = Reading.objects.create(
                    PK=uuid.uuid4(),
                    meterPK=meter,
                    timeoccurred=datetime.now(),
                    rawvalue=random.randint(0, 10000),
                    ismanual=0,
                    packettype=0,
                    packetdata="",
                    packettime=datetime.now(),
                    operatorusername="MobileAdministrator",
                )
                return reading
            else:
                reading = random.choice(Reading.objects.all())
                reading = random.choice(Reading.objects.all())
                reading.timeoccurred = datetime.now()
                reading.save()
                return reading
        except Exception as e:
            print(e)

    def delete_meter(self):
        try:
            meter = random.choice(Meter.objects.all())
            meter.delete()
        except Exception as e:
            print(e)

    def delete_extended_reading(self):
        try:
            extended_reading = random.choice(Extendedreading.objects.all())
            extended_reading.delete()
        except Exception as e:
            print(e)

    def delete_reading(self):
        try:
            reading = random.choice(Reading.objects.all())
            reading.delete()
        except Exception as e:
            print(e)
