import os
import sys
import cleargrid.mc3_integration.settings.local as local


def get_setting(name, default=None):
    return getattr(local, name, os.environ.get(name, default))


def define_db():
    config = {
        "NAME": "MIS",
        "ENGINE": "sql_server.pyodbc",
        "HOST": "\\".join([get_setting("DB_HOST", "127.0.0.1"), "ITRONMC"]),
    }
    username = get_setting("DB_USERNAME", None)
    password = get_setting("DB_PASSWORD", None)
    options = get_setting(
        "OPTIONS", {"driver": "ODBC Driver 11 for SQL Server"}
    )
    host = get_setting("DB_HOST", "\\".join(["127.0.0.1", "ITRONMC"]))

    if username is not None:
        config.update(USER=username)
    if password is not None:
        config.update(PASSWORD=password)
    if options is not None:
        config.update(OPTIONS=options)
    config.update(HOST=host)

    return config


BASE_DIR = os.path.dirname(os.path.abspath(__file__))

# DJANGO: PRODUCTION DATABASE
DATABASES = {"default": define_db()}

INSTALLED_APPS = ("cleargrid.mc3_integration.data",)

SECRET_KEY = "fly@123"

FILE_LOGGING_PATH = get_setting("LOG_PATH", "C:\\MC3_Integration")

API_SERVER = get_setting("API_SERVER", "http://127.0.0.1:80")
POLLING_INTERVAL = get_setting("POLLING_INTERVAL", 5)

TEST = get_setting("TEST", False)
if not TEST:
    TEST = "test" in sys.argv or "test_coverage" in sys.argv
