# Generated by Django 2.1.8 on 2019-06-30 22:26

from django.db import migrations, models
import django.db.models.deletion
# import cleargrid.mc3_integration.data.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Endpoint',
            fields=[
                ('PK', models.CharField(db_column='PK', default=uuid.uuid4, max_length=36, primary_key=True, serialize=False)),
                ('identifier', models.CharField(db_column='Identifier', max_length=18)),
                ('macaddress', models.CharField(db_column='MACAddress', max_length=12)),
                ('latitude', models.CharField(db_column='Latitude', max_length=17)),
                ('longitude', models.CharField(db_column='Longitude', max_length=17)),
                ('type', models.CharField(db_column='Type', max_length=32)),
                ('scmerttype', models.SmallIntegerField(db_column='SCMErtType')),
                ('deviceclass', models.SmallIntegerField(db_column='DeviceClass')),
                ('tamper1count', models.SmallIntegerField(db_column='Tamper1Count')),
                ('tamper2count', models.SmallIntegerField(db_column='Tamper2Count')),
                ('previoustamper1count', models.SmallIntegerField(db_column='PreviousTamper1Count')),
                ('previoustamper2count', models.SmallIntegerField(db_column='PreviousTamper2Count')),
            ],
            options={
                'db_table': 'EndPoint',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Endpointinformation',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('markettype', models.CharField(db_column='MarketType', max_length=1)),
                ('endpointphase', models.CharField(db_column='EndpointPhase', max_length=5)),
                ('minendpointid', models.CharField(db_column='MinEndpointID', max_length=18)),
                ('maxendpointid', models.CharField(db_column='MaxEndpointID', max_length=18)),
                ('isleaksensor', models.BooleanField(db_column='IsLeakSensor')),
                ('deviceclass', models.SmallIntegerField(db_column='DeviceClass')),
                ('comments', models.CharField(blank=True, db_column='Comments', max_length=50, null=True)),
            ],
            options={
                'db_table': 'EndpointInformation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Endpointlocation',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('endpointidentifier', models.CharField(db_column='EndPointIdentifier', max_length=18)),
                ('markettype', models.CharField(blank=True, db_column='MarketType', max_length=1, null=True)),
                ('uniqueid', models.CharField(blank=True, db_column='UniqueID', max_length=19, null=True, unique=True)),
                ('streetaddress', models.CharField(blank=True, db_column='StreetAddress', max_length=255, null=True)),
                ('city', models.CharField(blank=True, db_column='City', max_length=100, null=True)),
                ('region', models.CharField(blank=True, db_column='Region', max_length=100, null=True)),
                ('zip', models.CharField(blank=True, db_column='Zip', max_length=50, null=True)),
                ('country', models.CharField(blank=True, db_column='Country', max_length=100, null=True)),
                ('latitude', models.CharField(blank=True, db_column='Latitude', max_length=17, null=True)),
                ('longitude', models.CharField(blank=True, db_column='Longitude', max_length=17, null=True)),
                ('geopointsource', models.CharField(blank=True, db_column='GeoPointSource', max_length=255, null=True)),
            ],
            options={
                'db_table': 'EndPointLocation',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Extendeddlreading',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('extdlreq', models.CharField(db_column='ExtDLReqPK', max_length=36)),
                ('timeoccurred', models.DateTimeField(db_column='TimeOccurred')),
                ('operatorusername', models.CharField(db_column='OperatorUserName', max_length=15)),
                ('readdata1', models.TextField(db_column='ReadData1')),
            ],
            options={
                'db_table': 'ExtendedDLReading',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Extendeddlrequest',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('endpointidentifier', models.CharField(db_column='EndPointIdentifier', max_length=18)),
                ('markettype', models.CharField(db_column='MarketType', max_length=1)),
                ('sequencenumber', models.SmallIntegerField(db_column='SequenceNumber')),
                ('parentsequencenumber', models.SmallIntegerField(db_column='ParentSequenceNumber')),
                ('isrequired', models.BooleanField(db_column='IsRequired')),
                ('readstatus', models.SmallIntegerField(db_column='ReadStatus')),
                ('requestorigin', models.SmallIntegerField(db_column='RequestOrigin')),
                ('command', models.IntegerField(db_column='Command')),
                ('parameters', models.CharField(db_column='Parameters', max_length=40)),
                ('securedrequest1', models.CharField(db_column='SecuredRequest1', max_length=500)),
                ('securedrequest2', models.CharField(blank=True, db_column='SecuredRequest2', max_length=4000, null=True)),
                ('ismanual', models.BooleanField(db_column='IsManual')),
                ('isextended', models.BooleanField(db_column='IsExtended')),
                ('techdescriptor', models.SmallIntegerField(db_column='TechDescriptor')),
                ('commandinfo', models.CharField(db_column='CommandInfo', max_length=128)),
            ],
            options={
                'db_table': 'ExtendedDLRequest',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Extendedreading',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('meter', mc3_integration.data.models.UniqueIdentifierField(db_column='MeterPK', default=None, editable=False)),
                ('readdatetime', models.DateTimeField(db_column='ReadDateTime')),
                ('readstatus', models.SmallIntegerField(db_column='ReadStatus')),
                ('sequencenumber', models.SmallIntegerField(db_column='SequenceNumber')),
                ('readdata', models.CharField(db_column='ReadData', max_length=3600)),
            ],
            options={
                'db_table': 'ExtendedReading',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Lostmeter',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('identifier', models.CharField(db_column='Identifier', max_length=18)),
                ('markettype', models.CharField(db_column='MarketType', max_length=1)),
                ('scmerttype', models.SmallIntegerField(db_column='SCMErtType')),
                ('deviceclass', models.SmallIntegerField(db_column='DeviceClass')),
                ('estimatedlatitude', models.CharField(blank=True, db_column='EstimatedLatitude', max_length=17, null=True)),
                ('estimatedlongitude', models.CharField(blank=True, db_column='EstimatedLongitude', max_length=17, null=True)),
                ('assignedlatitude', models.CharField(blank=True, db_column='AssignedLatitude', max_length=17, null=True)),
                ('assignedlongitude', models.CharField(blank=True, db_column='AssignedLongitude', max_length=17, null=True)),
                ('state', models.IntegerField(db_column='State')),
                ('street', models.CharField(blank=True, db_column='Street', max_length=60, null=True)),
                ('comments', models.CharField(blank=True, db_column='Comments', max_length=300, null=True)),
                ('ismapped', models.BooleanField(db_column='IsMapped')),
            ],
            options={
                'db_table': 'LostMeter',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Lostmeterreading',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('lostmeterPK', models.CharField(db_column='LostMeterPK', max_length=36)),
                ('timeoccurred', models.DateTimeField(db_column='TimeOccurred')),
                ('rssi', models.IntegerField(db_column='RSSI')),
                ('latitude', models.CharField(blank=True, db_column='Latitude', max_length=17, null=True)),
                ('longitude', models.CharField(blank=True, db_column='Longitude', max_length=17, null=True)),
                ('packettype', models.SmallIntegerField(db_column='PacketType')),
                ('isradioread', models.BooleanField(db_column='IsRadioRead')),
                ('isconsumptiveerror', models.BooleanField(db_column='IsConsumptiveError')),
            ],
            options={
                'db_table': 'LostMeterReading',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('meterPK', models.CharField(db_column='MeterPK', max_length=36)),
                ('messageindicator', models.SmallIntegerField(db_column='MessageIndicator')),
                ('changedmessageindicator', models.BooleanField(db_column='ChangedMessageIndicator')),
                ('messagetext', models.CharField(blank=True, db_column='MessageText', max_length=160, null=True)),
            ],
            options={
                'db_table': 'Message',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Meter',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('street', models.CharField(db_column='Street', max_length=60)),
                ('messagecount', models.IntegerField(db_column='MessageCount')),
                ('isreadonly', models.BooleanField(db_column='IsReadOnly')),
                ('isoutofroute', models.BooleanField(db_column='IsOutofRoute')),
                ('isduplicateoor', models.BooleanField(db_column='IsDuplicateOOR')),
                ('identifier', models.CharField(db_column='Identifier', max_length=18)),
                ('sequencenumber', models.IntegerField(db_column='SequenceNumber')),
                ('symbolcode', models.IntegerField(db_column='SymbolCode')),
                ('externalmeterid', models.CharField(blank=True, db_column='ExternalMeterID', max_length=14, null=True)),
                ('dials', models.SmallIntegerField(blank=True, db_column='Dials', null=True)),
                ('decimals', models.SmallIntegerField(blank=True, db_column='Decimals', null=True)),
                ('typeofread', models.CharField(blank=True, db_column='TypeOfRead', max_length=6, null=True)),
                ('markettype', models.CharField(blank=True, db_column='MarketType', max_length=1, null=True)),
                ('readstatus', models.SmallIntegerField(blank=True, db_column='ReadStatus', null=True)),
                ('readcomplete', models.BooleanField(db_column='ReadComplete')),
                ('parentid', models.CharField(blank=True, db_column='ParentID', max_length=30, null=True)),
                ('nonamr', models.BooleanField(db_column='NonAMR')),
                ('locationcode', models.CharField(blank=True, db_column='LocationCode', max_length=2, null=True)),
                ('readinstructioncode1', models.CharField(blank=True, db_column='ReadInstructionCode1', max_length=2, null=True)),
                ('readinstructioncode2', models.CharField(blank=True, db_column='ReadInstructionCode2', max_length=2, null=True)),
                ('information', models.CharField(blank=True, db_column='Information', max_length=20, null=True)),
                ('activeindicator', models.CharField(blank=True, db_column='ActiveIndicator', max_length=1, null=True)),
                ('validationtype', models.SmallIntegerField(blank=True, db_column='ValidationType', null=True)),
                ('previousread', models.BigIntegerField(blank=True, db_column='PreviousRead', null=True)),
                ('high2', models.IntegerField(blank=True, db_column='High2', null=True)),
                ('high1', models.IntegerField(blank=True, db_column='High1', null=True)),
                ('low1', models.IntegerField(blank=True, db_column='Low1', null=True)),
                ('low2', models.IntegerField(blank=True, db_column='Low2', null=True)),
                ('positivedialcreep', models.SmallIntegerField(blank=True, db_column='PositiveDialCreep', null=True)),
                ('negativedialcreep', models.SmallIntegerField(blank=True, db_column='NegativeDialCreep', null=True)),
                ('troublemessage', models.CharField(blank=True, db_column='TroubleMessage', max_length=40, null=True)),
            ],
            options={
                'db_table': 'Meter',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Meterevent',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('type', models.CharField(db_column='Type', max_length=32)),
                ('timeoccurred', models.DateTimeField(db_column='TimeOccurred')),
                ('meterPK', models.ForeignKey(db_column='MeterPK', on_delete=django.db.models.deletion.DO_NOTHING, to='data.Meter')),
            ],
            options={
                'db_table': 'MeterEvent',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Reading',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('rawvalue', models.BigIntegerField(db_column='RawValue')),
                ('timeoccurred', models.DateTimeField(db_column='TimeOccurred')),
                ('ismanual', models.BooleanField(db_column='IsManual')),
                ('packettype', models.SmallIntegerField(db_column='PacketType')),
                ('packetdata', models.CharField(db_column='PacketData', max_length=100)),
                ('packettime', models.DateTimeField(db_column='PacketTime')),
                ('operatorusername', models.CharField(db_column='OperatorUserName', max_length=20)),
                ('meter', models.ForeignKey(db_column='MeterPK', on_delete=django.db.models.deletion.DO_NOTHING, related_name='reading', to='data.Meter')),
            ],
            options={
                'db_table': 'Reading',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Receivercount',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('cardindex', models.SmallIntegerField(db_column='CardIndex')),
                ('value', models.IntegerField(db_column='Value')),
            ],
            options={
                'db_table': 'ReceiverCount',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Route',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('identifier', models.CharField(db_column='Identifier', max_length=14)),
                ('primarystate', models.SmallIntegerField(db_column='PrimaryState')),
                ('secondarystate', models.SmallIntegerField(db_column='SecondaryState')),
                ('unit', models.CharField(db_column='Unit', max_length=8)),
                ('company', models.CharField(db_column='Company', max_length=31)),
                ('frequencytext', models.CharField(db_column='FrequencyText', max_length=7)),
                ('operator', models.CharField(db_column='Operator', max_length=16)),
                ('tone', models.IntegerField(db_column='Tone')),
                ('frequency', models.FloatField(db_column='Frequency')),
                ('fromhostname', models.CharField(db_column='FromHostName', max_length=13)),
                ('originalertcount', models.IntegerField(db_column='OriginalErtCount')),
                ('collectoutofroute', models.BooleanField(db_column='CollectOutOfRoute')),
                ('definition', models.CharField(db_column='Definition', max_length=18)),
                ('sortflag', models.SmallIntegerField(db_column='SortFlag')),
                ('sorttype', models.SmallIntegerField(db_column='SortType')),
                ('checkdigit', models.SmallIntegerField(db_column='CheckDigit')),
                ('metertypesincluded', models.SmallIntegerField(db_column='MeterTypesIncluded')),
                ('frequencyselector', models.SmallIntegerField(db_column='FrequencySelector')),
                ('expectedrundate', models.DateTimeField(db_column='ExpectedRunDate')),
                ('basefilename', models.CharField(db_column='BaseFileName', max_length=32)),
                ('fileformat', models.CharField(db_column='FileFormat', max_length=1)),
                ('ekaimportindicator', models.SmallIntegerField(db_column='EkaImportIndicator')),
                ('maxmtrmsglength', models.SmallIntegerField(db_column='MaxMtrMsgLength')),
                ('message', models.CharField(db_column='Message', max_length=160)),
                ('filespackaged', models.BooleanField(db_column='FilesPackaged')),
                ('dldatetimeformat', models.SmallIntegerField(db_column='DLDateTimeFormat')),
                ('firstimportdate', models.DateTimeField(db_column='FirstImportDate')),
                ('firststartprocessingdate', models.DateTimeField(db_column='FirstStartProcessingDate')),
                ('firstinroutereaddate', models.DateTimeField(db_column='FirstInRouteReadDate')),
                ('firstoorreaddate', models.DateTimeField(db_column='FirstOORReadDate')),
                ('laststopprocessingdate', models.DateTimeField(db_column='LastStopProcessingDate')),
                ('lastcompletedate', models.DateTimeField(db_column='LastCompleteDate')),
                ('readingkeylistdate', models.DateTimeField(db_column='ReadingKeyListDate')),
                ('readingkeylist', models.BinaryField(db_column='ReadingKeyList')),
                ('modechangetype', models.SmallIntegerField(db_column='ModeChangeType')),
            ],
            options={
                'db_table': 'Route',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Routemessage',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('sequencenumber', models.IntegerField(db_column='SequenceNumber')),
                ('messageheader', models.CharField(db_column='MessageHeader', max_length=50)),
                ('message', models.CharField(db_column='Message', max_length=150)),
                ('routePK', models.ForeignKey(db_column='RoutePK', on_delete=django.db.models.deletion.DO_NOTHING, to='data.Route')),
            ],
            options={
                'db_table': 'RouteMessage',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Routestatistic',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('activetime', models.BigIntegerField(db_column='ActiveTime')),
                ('missedoutofroutereadcount', models.IntegerField(db_column='MissedOutOfRouteReadCount')),
                ('routePK', models.ForeignKey(db_column='RoutePK', on_delete=django.db.models.deletion.DO_NOTHING, to='data.Route')),
            ],
            options={
                'db_table': 'RouteStatistic',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Routetoneoverride',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('routeidentifier', models.CharField(db_column='RouteIdentifier', max_length=14)),
                ('tone', models.IntegerField(db_column='Tone')),
            ],
            options={
                'db_table': 'RouteToneOverride',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Schemaversion',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('value', models.CharField(db_column='Value', max_length=20)),
                ('iscurrentversion', models.BooleanField(db_column='IsCurrentVersion')),
                ('fpdatetime', models.DateTimeField(db_column='FpDateTime')),
            ],
            options={
                'db_table': 'SchemaVersion',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Segment',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('identifier', models.IntegerField(db_column='Identifier')),
                ('definition', models.CharField(db_column='Definition', max_length=31)),
                ('routePK', models.ForeignKey(db_column='RoutePK', on_delete=django.db.models.deletion.DO_NOTHING, to='data.Route')),
            ],
            options={
                'db_table': 'Segment',
                'managed': True,
            },
        ),
        migrations.CreateModel(
            name='Settings',
            fields=[
                ('PK', models.CharField(db_column='PK', max_length=36, primary_key=True, serialize=False)),
                ('readingkeylistdate', models.DateTimeField(db_column='ReadingKeyListDate')),
                ('readingkeylist', models.BinaryField(db_column='ReadingKeyList')),
                ('readingkeypassphrase', models.BinaryField(db_column='ReadingKeyPassPhrase')),
            ],
            options={
                'db_table': 'Settings',
                'managed': True,
            },
        ),
        migrations.AddField(
            model_name='receivercount',
            name='routestatisticpk',
            field=models.ForeignKey(db_column='RouteStatisticPK', on_delete=django.db.models.deletion.DO_NOTHING, to='data.Routestatistic'),
        ),
        migrations.AddField(
            model_name='meter',
            name='routePK',
            field=models.ForeignKey(blank=True, db_column='RoutePK', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='data.Route'),
        ),
        migrations.AddField(
            model_name='meter',
            name='segmentPK',
            field=models.ForeignKey(blank=True, db_column='SegmentPK', null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='data.Segment'),
        ),
        migrations.AddField(
            model_name='extendeddlrequest',
            name='meter',
            field=models.ForeignKey(db_column='MeterPK', on_delete=django.db.models.deletion.DO_NOTHING, related_name='extended_dl_requests', to='data.Meter'),
        ),
        migrations.AddField(
            model_name='endpoint',
            name='meter',
            field=models.ForeignKey(db_column='MeterPK', default=uuid.uuid4, on_delete=django.db.models.deletion.DO_NOTHING, related_name='endpoint', to='data.Meter'),
        ),
        migrations.AlterUniqueTogether(
            name='receivercount',
            unique_together={('routestatisticpk', 'cardindex')},
        ),
    ]
