# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cleargrid',
 'cleargrid.r900',
 'cleargrid.r900.galois',
 'cleargrid.r900.input_filters']

package_data = \
{'': ['*']}

install_requires = \
['cymem>=2.0.3,<3.0.0',
 'cython>=0.29.16,<0.30.0',
 'matplotlib>=3.2.1,<4.0.0',
 'numba>=0.49.0,<0.50.0',
 'numpy>=1.18.3,<2.0.0']

entry_points = \
{'console_scripts': ['decode_r900 = cleargrid.r900.decode:main']}

setup_kwargs = {
    'name': 'r900-decode',
    'version': '0.1.1',
    'description': 'Decoder for Neptune R900 messages',
    'long_description': None,
    'author': 'Bjorn Harpe',
    'author_email': 'bjorn.harpe@cleargrid.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
