from cymem.cymem cimport Pool
from libc.stdint cimport *

cpdef uint8_t nbit(uint8_t p):
    cdef uint8_t n = 0
    while p > 0:
        p >>= 1
        n += 1
    return n


cpdef uint8_t polydiv(uint8_t p, uint8_t q):
    cdef uint8_t np = nbit(p)
    cdef uint8_t nq = nbit(q)
    while np >= nq:
        if p & (1 << (np - 1)) != 0:
            p ^= q << (np - nq)
        np -= 1
    return p


cpdef bint reducible(uint8_t p):
    cdef uint8_t np = nbit(p)
    cdef uint8_t end = 1 << (np // 2 + 1)
    for q in range(2, end):
        if polydiv(p, q) == 0:
            return True
    return False


cpdef uint8_t mul(uint8_t x, uint8_t y, uint8_t order, uint8_t poly):
    cdef uint8_t z = 0
    while x > 0:
        if x & 1 != 0:
            z ^= y
        x >>= 1
        y <<= 1
        if y & order != 0:
            y ^= poly
    return z

