import pyximport

pyximport.install()

import logging
from .math import *


class FieldError(ValueError):
    pass


class Field:
    def __init__(self, order: int, poly: int, alpha: int):
        if order < 0 or order > 256:
            raise FieldError("Invalid order")
        if poly < order or poly >= order << 1 or reducible(poly):
            raise FieldError("Invalid polynomial")

        self.order = order - 1
        self._exp = [x := 1,] + [
            x := mul(x, alpha, order, poly) for _ in range(self.order - 1)
        ]
        self._log = [None for i in range(order)]
        for i, e in enumerate(self._exp):
            self._log[e] = i

        self._exp *= 2
        self._log[0] = self.order
        self._check()

    def _check(self):
        for i, e in enumerate(self._exp):
            if self._log[e] != i % self.order:
                print(i, e)
                print(self._log[e], "!=", i % self.order)
                raise FieldError("Bad Log")
        for i, l in enumerate(self._log[1:]):
            if self._exp[l] != i + 1:
                raise FieldError("Bad Log")

    def add(self, x, y):
        return x ^ y

    def exp(self, e):
        if e < 0:
            return 0
        return self._exp[e % self.order]

    def log(self, x):
        if x == 0:
            return -1
        return int(self._log[x])

    def inv(self, x):
        if x == 0:
            return 0
        return self._exp[self.order - int(self._log[x])]

    def mul(self, x, y):
        if x == 0 or y == 0:
            return 0
        return self._exp[int(self._log[x]) + int(self._log[y])]

    def syndrome(self, message, parity_symbol_count, offset):
        if offset < 0 or offset > self.order:
            raise FieldError("Invalid offset")
        if parity_symbol_count < 0 or parity_symbol_count > len(message):
            raise FieldError("Inavalid parity symbol count")

        syndrome = [None for i in range(parity_symbol_count)]
        for idx, syn in enumerate(syndrome):
            syn = message[0]
            for v in message[1:]:
                syn = self.mul(syn, self.exp(offset + idx)) ^ v
            syndrome[idx] = syn
        return syndrome


__all__ = ["Field", "FieldError"]
