from logging.handlers import RotatingFileHandler


class OnRunRotatingFileHandler(RotatingFileHandler):
    """
    Handler for logging that rotates the logfile *only* when the application
    starts up.
    """

    def __init__(self, filename, backupCount=0, encoding=None, delay=False):
        super().__init__(
            filename,
            mode="a",
            maxBytes=0,
            backupCount=backupCount,
            encoding=encoding,
            delay=delay,
        )
        self.doRollover()

    def shouldRollover(self, record):
        """Never rollover while running"""
        return 0
